function ht = tipGap(N, TC, BC, t1, t2)
%this function evaluate radial clearance distribution around gear
%INPUT
%N : number of contemporaty sealed volumes
%TC : nominal radial clearance [mm]
%BC : nominal bearing block clearance [mm] (optional)
%t1 : angular coordinate of last tooth in contact w/ casing [deg]
%t2 : angular coordinate of first tooth in contact w/ casing [deg]
%OUTPUT:
%ht : radial clearances in the sealed volume. ht is a (N+1) long vector


%read updated gear eccentricity from Excel file [(X, Y) coordinates]
filename = 'BearingCenterCoord.xlsx'; 
M =  readmatrix(filename,'Sheet', 1, 'Range', 'A2');
xbear = M(end, 1); ybear = M(end, 2); 

%bearing block displacement contribution (if considered) : vertically
%towards suction side
ybear = ybear - BC;

%from (X,Y) coord. (cartesian) to (e,Gamma) coord. (polar)
e = sqrt( xbear^2 + ybear^2 );
GAMMA =  rad2deg(mod(atan2(ybear, xbear), 2*pi));

%Initialize radial clearance vector (N sealed vanes, N+1 teeth tips in
%contact w/ casing)
ht_nom = TC*ones(1, N + 1);

%Angular coordinates of all sealed teeth tips between last and first
tt = t1 + (0:N).*(t2 - t1)/N;
%Use formula to calculate radial clearance for each tooth tip (from last to
%first)
ht = ht_nom - e.*cosd(tt - GAMMA); 
%Flip vector for correct order in ODE sistem (from first to last)
ht = flip(ht);

end